/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.managed;

import com.ibm.hwmca.base.constask.ConsoleTasks;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.HwmcaObject;
import com.ibm.hwmca.fw.managed.ManagedObject;
import com.ibm.hwmca.fw.managed.ManagedObjectGroup;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.TaskProperties;
import com.ibm.hwmca.fw.managed.User;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.settings.user.ConfirmationSettings;
import com.ibm.hwmca.fw.task.PresentationTaskParms;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Task
extends HwmcaObject
implements TaskProperties {
    private boolean isTargetRequired = true;
    private boolean isAnyPermitted = false;
    private HashSet permittedObjects;
    private String presentationTaskClassName = null;
    private boolean disruptive = false;
    private boolean canExecuteRemotely = true;
    private boolean singleTarget = false;
    private boolean requireCommunications = false;
    private boolean acceptsBusyTargets = false;
    private boolean busyTargets = true;
    private boolean updateTargetsLastTaskName = true;
    private LocalizableText confirmationText = null;
    private Object permittedObjectsMonitor = new Object();
    private List associatedTasklets = Collections.synchronizedList(new ArrayList());
    private boolean promptForTargets = false;
    private boolean relockAllowed = true;
    private String mergedKey;
    private static final FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(85, "Task");
    private static final String TRACE_MASKT = "XFRMTSKT";
    private static final String TRACE_MASKF = "XFRMTSKF";
    private static final String TRACE_MASKD = "XFRMTKSD";
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$Task;

    public Task(String name, UIInfo uiInfo) {
        if (this.getClass().equals(class$com$ibm$hwmca$fw$managed$Task == null ? (class$com$ibm$hwmca$fw$managed$Task = Task.class$("com.ibm.hwmca.fw.managed.Task")) : class$com$ibm$hwmca$fw$managed$Task)) {
            Trace.trace(TRACE_MASKT, "<> Task(name=" + name + ")");
        }
        ObjectId id = new ObjectId(this);
        if (name != null) {
            id.setKeyProperty("Name", name);
        }
        this.setObjectId(id);
        this.uiInfo = uiInfo;
        this.permittedObjects = new HashSet();
    }

    public Task(PersistentData data, String persistKey) {
        super(((Persistent)data).parentData, persistKey);
        if (this.getClass().equals(class$com$ibm$hwmca$fw$managed$Task == null ? (class$com$ibm$hwmca$fw$managed$Task = Task.class$("com.ibm.hwmca.fw.managed.Task")) : class$com$ibm$hwmca$fw$managed$Task)) {
            Trace.trace(TRACE_MASKT, "<> Task(data=" + data + ", persistKey=" + persistKey + ")");
        }
        this.presentationTaskClassName = ((Persistent)data).presentationTaskClassName;
        this.isTargetRequired = ((Persistent)data).isTargetRequired;
        this.isAnyPermitted = ((Persistent)data).isAnyPermitted;
        this.permittedObjects = ((Persistent)data).permittedObjects;
        this.disruptive = ((Persistent)data).disruptive;
        this.canExecuteRemotely = ((Persistent)data).canExecuteRemotely;
        this.singleTarget = ((Persistent)data).singleTarget;
        this.requireCommunications = ((Persistent)data).requireCommunications;
        this.confirmationText = ((Persistent)data).confirmationText;
        if (((Persistent)data).associatedTasklets != null) {
            this.associatedTasklets.add(Arrays.asList(((Persistent)data).associatedTasklets));
        }
        this.promptForTargets = ((Persistent)data).promptForTargets;
        this.relockAllowed = ((Persistent)data).relockAllowed;
    }

    public String getName() {
        String result = (String)this.getObjectId().getKeyProperty("Name");
        if (result == null) {
            result = "";
        }
        return result;
    }

    public String getPresentationTaskClassName() {
        return this.presentationTaskClassName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPresentationTaskClassName(String presentationTaskClassName) {
        Trace.trace(TRACE_MASKF, "-> setPresentationTaskClassName(presentationTaskClassName=" + presentationTaskClassName + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            String oldPresentationTaskClassName = this.presentationTaskClassName;
            this.presentationTaskClassName = presentationTaskClassName;
            this.firePropertyChange("PresentationTaskClassName", oldPresentationTaskClassName, presentationTaskClassName);
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKF, "<- setPresentationTaskClassName()");
    }

    public boolean isDisruptive() {
        return this.disruptive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisruptive(boolean disruptive) {
        Trace.trace(TRACE_MASKF, "-> setDisruptive(disruptive=" + disruptive + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            boolean oldDisruptive = this.disruptive;
            this.disruptive = disruptive;
            this.firePropertyChange("Disruptive", oldDisruptive, disruptive);
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKF, "<- setDisruptive()");
    }

    public boolean canExecuteRemotely() {
        return this.canExecuteRemotely;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCanExecuteRemotely(boolean canExecuteRemotely) {
        Trace.trace(TRACE_MASKF, "-> setCanExecuteRemotely(canExecuteRemotely=" + canExecuteRemotely + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            boolean oldCanExecuteRemotely = this.canExecuteRemotely;
            this.canExecuteRemotely = canExecuteRemotely;
            this.firePropertyChange("CanExecuteRemotely", oldCanExecuteRemotely, canExecuteRemotely);
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKF, "<- setCanExecuteRemotely()");
    }

    public boolean isTargetRequired() {
        return this.isTargetRequired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTargetRequired(boolean isTargetRequired) {
        Trace.trace(TRACE_MASKF, "-> setTargetRequired(isTargetRequired=" + isTargetRequired + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            boolean oldIsTargetRequired = this.isTargetRequired;
            this.isTargetRequired = isTargetRequired;
            this.firePropertyChange("TargetRequired", oldIsTargetRequired, isTargetRequired);
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKF, "<- setTargetRequired()");
    }

    public boolean isAnyPermitted() {
        return this.isAnyPermitted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAnyPermitted(boolean isAnyPermitted) {
        Trace.trace(TRACE_MASKF, "-> setAnyPermitted(isAnyPermitted=" + isAnyPermitted + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            boolean oldIsAnyPermitted = this.isAnyPermitted;
            this.isAnyPermitted = isAnyPermitted;
            this.firePropertyChange("AnyPermitted", oldIsAnyPermitted, isAnyPermitted);
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKF, "<- setAnyPermitted()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getPermittedObjects() {
        Object object = this.permittedObjectsMonitor;
        synchronized (object) {
            return (Set)this.permittedObjects.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPermittedObject(String permittedObject) {
        boolean exists;
        Trace.trace(TRACE_MASKF, "-> addPermittedObject(permittedObject=" + permittedObject + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            Object object2 = this.permittedObjectsMonitor;
            synchronized (object2) {
                exists = this.permittedObjects.contains(permittedObject);
                if (!exists) {
                    this.permittedObjects.add(permittedObject);
                }
            }
            if (!exists) {
                this.fireContainerPropertyAdd("PermittedObjects", new String[]{permittedObject});
            }
        }
        if (!exists) {
            this.autoPersist();
        }
        Trace.trace(TRACE_MASKF, "<- addPermittedObject()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPermittedObjects(Collection permittedObjects) {
        Trace.trace(TRACE_MASKF, "-> addPermittedObjects(permittedObjects=" + permittedObjects + ")");
        HashSet uniqueNewPermittedObjects = new HashSet();
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            String[] permittedObjectArray = null;
            Object object2 = this.permittedObjectsMonitor;
            synchronized (object2) {
                if (permittedObjects != null) {
                    uniqueNewPermittedObjects.addAll(permittedObjects);
                    uniqueNewPermittedObjects.removeAll(this.permittedObjects);
                    this.permittedObjects.addAll(permittedObjects);
                }
                if (uniqueNewPermittedObjects.size() > 0) {
                    permittedObjectArray = new String[uniqueNewPermittedObjects.size()];
                    uniqueNewPermittedObjects.toArray(permittedObjectArray);
                }
            }
            if (uniqueNewPermittedObjects.size() > 0) {
                this.fireContainerPropertyAdd("PermittedObjects", permittedObjectArray);
            }
        }
        if (uniqueNewPermittedObjects.size() > 0) {
            this.autoPersist();
        }
        Trace.trace(TRACE_MASKF, "<- addPermittedObjects()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPermittedObjects(Set permittedObjects) {
        Trace.trace(TRACE_MASKF, "-> setPermittedObjects(permittedObjects=" + permittedObjects + ")");
        String[] oldPermittedObjects = null;
        String[] newPermittedObjects = null;
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            Object object2 = this.permittedObjectsMonitor;
            synchronized (object2) {
                HashSet uniqueNewPermittedObjects = new HashSet();
                HashSet uniqueOldPermittedObjects = new HashSet(this.permittedObjects);
                if (permittedObjects != null) {
                    uniqueNewPermittedObjects.addAll(permittedObjects);
                    uniqueNewPermittedObjects.removeAll(this.permittedObjects);
                    newPermittedObjects = new String[uniqueNewPermittedObjects.size()];
                    uniqueNewPermittedObjects.toArray(newPermittedObjects);
                    uniqueOldPermittedObjects.removeAll(permittedObjects);
                }
                oldPermittedObjects = new String[uniqueOldPermittedObjects.size()];
                uniqueOldPermittedObjects.toArray(oldPermittedObjects);
                this.permittedObjects.clear();
                if (permittedObjects != null) {
                    this.permittedObjects.addAll(permittedObjects);
                }
            }
            this.firePropertyChange("PermittedObjects", oldPermittedObjects, newPermittedObjects);
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKF, "<- setPermittedObjects()");
    }

    public boolean isObjectPermitted(ManagedObject object) {
        return this.isObjectPermitted(object.getTargetId());
    }

    public boolean isObjectPermitted(ManagedObjectGroup object) {
        return this.isObjectPermitted(object.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isObjectPermitted(String targetId) {
        Object object = this.permittedObjectsMonitor;
        synchronized (object) {
            boolean permitted = this.isAnyPermitted();
            if (!permitted) {
                permitted = this.permittedObjects.contains(targetId);
            }
            Trace.trace(TRACE_MASKD, "<> Task isObjectPermitted returning " + permitted + ".");
            return permitted;
        }
    }

    public void updateTasksPerformed(PresentationTaskParms parms) {
        Trace.trace(TRACE_MASKF, "-> updateTasksPerformed()");
        try {
            ConsoleTasks.updateTasksPerformed(parms);
        }
        catch (Exception exc) {
            new FrameworkLog(logInfo, 2454, exc).log();
        }
        Trace.trace(TRACE_MASKF, "<- updateTasksPerformed()");
    }

    public boolean isSingleTarget() {
        return this.singleTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSingleTarget(boolean singleTarget) {
        Trace.trace(TRACE_MASKF, "-> setSingleTarget(singleTarget=" + singleTarget + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            boolean oldSingleTarget = this.singleTarget;
            this.singleTarget = singleTarget;
            this.firePropertyChange("SingleTarget", oldSingleTarget, singleTarget);
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKF, "<- setSingleTarget()");
    }

    public boolean acceptsBusyTargets() {
        return this.acceptsBusyTargets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAcceptsBusyTargets(boolean acceptsBusyTargets) {
        Trace.trace(TRACE_MASKF, "-> setAcceptsBusyTargets(acceptsBusyTargets=" + acceptsBusyTargets + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            boolean oldAcceptsBusyTargets = this.acceptsBusyTargets;
            this.acceptsBusyTargets = acceptsBusyTargets;
            this.firePropertyChange("AcceptsBusyTargets", oldAcceptsBusyTargets, acceptsBusyTargets);
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKF, "<- setAcceptsBusyTargets()");
    }

    public boolean busyTargets() {
        return this.busyTargets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBusyTargets(boolean busyTargets) {
        Trace.trace(TRACE_MASKF, "-> setBusyTargets(busyTargets=" + busyTargets + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            boolean oldBusyTargets = this.busyTargets;
            this.busyTargets = busyTargets;
            this.firePropertyChange("BusyTargets", oldBusyTargets, busyTargets);
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKF, "<- setBusyTargets()");
    }

    public boolean isRequireCommunications() {
        return this.requireCommunications;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRequireCommunications(boolean requireCommunications) {
        Trace.trace(TRACE_MASKF, "-> setRequireCommunications(requireCommunications=" + requireCommunications + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            boolean oldRequireCommunications = this.requireCommunications;
            this.requireCommunications = requireCommunications;
            this.firePropertyChange("RequireCommunications", oldRequireCommunications, requireCommunications);
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKF, "<- setRequireCommunications()");
    }

    public boolean isConfirmationDesired(ManagedObject[] targets) {
        ConfirmationSettings cs;
        boolean result = false;
        if (this.getConfirmationTexts(targets) != null && ((cs = (ConfirmationSettings)User.getUser().getAllUserSettings().get("com.ibm.hwmca.fw.settings.user.ConfirmationSettings")).showConfirmations() || cs.showWithObjectList())) {
            result = true;
        }
        return result;
    }

    public LocalizableText getConfirmationText() {
        return this.confirmationText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfirmationText(LocalizableText text) {
        Trace.trace(TRACE_MASKF, "-> setConfirmationText(text=" + text.getKey() + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            LocalizableText oldConfirmationText = this.confirmationText;
            this.confirmationText = text;
            this.firePropertyChange("ConfirmationText", oldConfirmationText, this.confirmationText);
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKF, "<- setConfirmationText()");
    }

    public LocalizableText[] getConfirmationTexts(ManagedObject[] targets) {
        LocalizableText[] text = null;
        if (this.confirmationText != null) {
            text = new LocalizableText[targets.length];
            for (int ix = 0; ix < targets.length; ++ix) {
                text[ix] = this.confirmationText;
            }
        }
        return text;
    }

    public List checkTargets(PresentationTaskParms parms) {
        return null;
    }

    public ManagedObject[] checkSecondaryTargets(PresentationTaskParms parms) {
        return null;
    }

    public ObjectId[] updateInitialTargets(ObjectId[] ids) {
        return ids;
    }

    public void addAssociatedTasklet(String taskletName) {
        this.associatedTasklets.add(taskletName);
    }

    public void removeAssociatedTasklet(String taskletName) {
        while (this.associatedTasklets.remove(taskletName)) {
        }
    }

    public List getAssociatedTasklets() {
        return new ArrayList(this.associatedTasklets);
    }

    public boolean updateTargetsLastTaskName() {
        return this.updateTargetsLastTaskName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpdateTargetsLastTaskName(boolean updateTargetsLastTaskName) {
        Trace.trace(TRACE_MASKF, "-> setUpdateTargetsLastTaskName(updateTargetsLastTaskName=" + updateTargetsLastTaskName + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            boolean oldUpdateTargetsLastTaskName = this.updateTargetsLastTaskName;
            this.updateTargetsLastTaskName = updateTargetsLastTaskName;
            this.firePropertyChange("UpdateTargetsLastTaskName", oldUpdateTargetsLastTaskName, updateTargetsLastTaskName);
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKF, "<- setUpdateTargetsLastTaskName()");
    }

    public boolean promptForTargets() {
        return this.promptForTargets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPromptForTargets(boolean prompt) {
        Trace.trace(TRACE_MASKF, "-> setPromptForTargets(prompt=" + prompt + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            boolean oldPromptForTargets = this.promptForTargets;
            this.promptForTargets = prompt;
            this.firePropertyChange("PromptForTargets", oldPromptForTargets, prompt);
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKF, "<- setPromptForTargets()");
    }

    public LocalizableText getPromptTextForTarget(ObjectId objectId) {
        return null;
    }

    public boolean isRelockAllowed() {
        return this.relockAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRelockAllowed(boolean relock) {
        Trace.trace(TRACE_MASKF, "-> setRelockAllowed(relock=" + relock + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            this.relockAllowed = relock;
            this.firePropertyChange("PromptForTargets", !this.relockAllowed, this.relockAllowed);
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKF, "<- setRelockAllowed()");
    }

    public String getMergedKey() {
        return this.mergedKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMergedKey(String mergedKey) {
        Trace.trace(TRACE_MASKF, "-> setMergedKey(mergedKey=" + mergedKey + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            String oldMergedKey = this.mergedKey;
            this.mergedKey = mergedKey;
            this.firePropertyChange("MergedKey", oldMergedKey, mergedKey);
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKF, "<- setMergedKey()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistentData getPersistentData() {
        Persistent result = new Persistent();
        result.parentData = super.getPersistentData();
        result.presentationTaskClassName = this.presentationTaskClassName;
        result.isTargetRequired = this.isTargetRequired;
        result.isAnyPermitted = this.isAnyPermitted;
        Object object = this.permittedObjectsMonitor;
        synchronized (object) {
            result.permittedObjects = this.permittedObjects;
        }
        result.disruptive = this.disruptive;
        result.canExecuteRemotely = this.canExecuteRemotely;
        result.singleTarget = this.singleTarget;
        result.confirmationText = this.confirmationText;
        result.requireCommunications = this.requireCommunications;
        if (this.associatedTasklets != null && this.associatedTasklets.size() > 0) {
            Persistent.access$002(result, this.associatedTasklets.toArray(new String[this.associatedTasklets.size()]));
        } else {
            Persistent.access$002(result, null);
        }
        result.promptForTargets = this.promptForTargets;
        result.mergedKey = this.mergedKey;
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Persistent
    implements PersistentData {
        int version = 0;
        PersistentData parentData;
        String presentationTaskClassName;
        boolean isTargetRequired;
        boolean isAnyPermitted;
        HashSet permittedObjects;
        boolean disruptive;
        boolean canExecuteRemotely;
        boolean singleTarget;
        boolean requireCommunications;
        boolean acceptsBusyTargets;
        boolean busyTargets;
        LocalizableText confirmationText;
        private String[] associatedTasklets;
        boolean promptForTargets;
        boolean relockAllowed;
        private String mergedKey;
        private static final long serialVersionUID = 7682235399073433570L;

        private Persistent() {
        }

        static /* synthetic */ String[] access$002(Persistent x0, String[] x1) {
            x0.associatedTasklets = x1;
            return x1;
        }
    }
}

